﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Data
Imports System.Data.SqlClient
Imports System.Text
Imports System.Text.RegularExpressions
Public Class MainForm
    Private _hasCreatedSprocs As Boolean = False
    Private Function ParseScriptToCommands(ByVal script As String) As String()
        Dim commands() As String
        commands = Regex.Split(script, _
                                "GO\r\n", _
                                RegexOptions.IgnoreCase)
        Return commands
    End Function

#Region "创建数据库、表和过程"
    ' 此子例程处理“Create Sprocs”（创建存储过程）按钮的 Click事件，在
    ' “Create Sprocs”（创建存储过程）选项卡上可找到该按钮。此例程使用
    ' System.Data.SqlClient 命名空间中的类执行 SQL 语句，这些 SQL 语句删除一个存储
    ' 过程（如果存在），然后创建该存储过程。
    Private Sub btnCreateSprocs_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateDatabase.Click

        Me.Cursor = Cursors.WaitCursor
        Try
            ' 打开连接，并在最后一条 SQL 语句执行完之前使其保持
            ' 打开状态。
            Using conn As New SqlConnection(My.Settings.MasterInstanceConnectionString)
                conn.Open()
                CreateDatabase(conn)
                btnCreateDatabase.Enabled = False
            End Using
        Catch sqlExc As SqlException
            MsgBox(sqlExc.ToString, MsgBoxStyle.OkOnly, "SQL Exception Error")
        Catch ex As Exception
            MsgBox("To run this sample, you must have SQL Express or SQL Server " & _
                        "and the Northwind database installed." & vbCrLf & _
                        ex.ToString(), MsgBoxStyle.Critical, "Connection failed.")
        Finally
            Me.Cursor = Cursors.Default
        End Try
    End Sub
#End Region

#Region "创建数据库和表"
    ' 此例程执行 SQL 语句，该语句删除一个数据库（如果存在），
    ' 然后创建该数据库。 
    Private Sub CreateDatabase(ByVal connection As SqlConnection)

        ' SqlCommand 对象用于执行 SQL 命令。
        Using cmd As New SqlCommand()
            cmd.Connection = connection

            cmd.CommandText = My.Resources.DataBaseCreationScripts.CreateDatabase
            cmd.ExecuteNonQuery()
            ' 获取要对数据库执行的命令的集合
            Dim commands() As String = Nothing
            commands = ParseScriptToCommands(My.Resources.DataBaseCreationScripts.CreateEmployeesTable)
            For Each command As String In commands
                cmd.CommandText = command
                cmd.ExecuteNonQuery()
            Next

            commands = ParseScriptToCommands(My.Resources.DataBaseCreationScripts.CreateSprocs)
            ' 打开连接，执行命令，然后关闭
            ' 连接。在没返回数据时 ExecuteNonQuery
            ' 更为有效。
            ' 因为命令在执行多项任务时与脚本的关联更加紧密
            ' 利用 My.Resources 来为每个 commandText 存储脚本
            ' 这会启用创建脚本的调试，
            ' 但不推荐典型的查询命令使用
            For Each command As String In commands
                If command.Trim().Length > 0 Then
                    cmd.CommandText = command
                    cmd.ExecuteNonQuery()
                End If
            Next
        End Using

        MsgBox("Database 'StoredProceduresDemo' successfully created.", _
            MsgBoxStyle.OkOnly, "Database Creation Status")
        _hasCreatedSprocs = True
    End Sub
#End Region

#Region "获取 <Output Params>（输出参数）选项卡的计数"

    ' 此子例程处理“Get Count”（获取计数）按钮的 Click 事件，
    ' 可在“All Types”（所有类型）选项卡上找到此按钮。此处
    ' 使用的存储过程需要单个输入参数，并发送回一个输出
    ' 参数值及一个返回值。执行存储过程后，
    ' 使用一个标签显示结果。
    Private Sub btnGetCountInCountry_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetCountInCountry.Click

        Dim dbConnection As New SqlConnection(My.Settings.NorthwindConnectionString)
        Dim command As New SqlCommand("CountPeopleInCountry", dbConnection)
        Dim adapter As New SqlDataAdapter(command)
        Dim dsEmployees As New DataSet()

        command.CommandType = CommandType.StoredProcedure

        ' 添加存储过程所需的参数。将
        ' 输入参数的值设置为 ComboBox 控件的选定值。
        ' 设置输出参数的“Direction”（方向）。最后，添加一个参数以
        ' 捕获返回值，即由 RETURN 语句从存储过程发送回
        ' 的值（或者，如果存储过程中没有显式使用 RETURN，
        ' 则为 SQL Server 返回的
        ' 默认成功/失败代码）。
        With command.Parameters
            .Add(New SqlParameter("@Country", SqlDbType.NVarChar)).Value = _
                cboCountries.SelectedValue
            ' 默认情况下，“Direction”（方向）属性的值为“Input”，
            ' 所以只需在下面两个参数中
            ' 显式设置“Direction”（方向）。
            .Add(New SqlParameter("@CountInCountry", _
                SqlDbType.Money)).Direction = ParameterDirection.Output
            ' 除了添加 SqlParameter 以获取返回值之外，
            ' 还可以声明一个整型变量并将其初始化
            ' 为 SqlDataAdapter Fill 方法返回的值，或
            ' 用于执行 SQL 语句的任何方法返回的值
            ' （如同上面 CREATE "GetEmployees" 存储过程
            ' 所做的那样）。
            .Add(New SqlParameter("ReturnValue", _
                SqlDbType.Int)).Direction = ParameterDirection.ReturnValue
        End With

        Try
            ' 有关此行代码的注释，请参见 frmMain Load 事件处理程序中的
            ' Try...Catch 块。
            adapter.Fill(dsEmployees, "Employee")

        Catch expSQL As SqlException
            MsgBox(expSQL.ToString, MsgBoxStyle.OkOnly, "SQL Exception")
            Exit Sub
        End Try

        ' 显示结果。
        lblProductCountAndAvgPrice.Text = _
            String.Format("There are {0} employees in {1}.", _
                command.Parameters("ReturnValue").Value, _
                cboCountries.Text)
    End Sub
#End Region

#Region "获取 <Input Param>（输入参数）选项卡的 <Employees>（雇员）"
    ''' <summary>
    ''' 此子例程处理“Get Employees”（获取雇员）按钮的 Click 事件处理程序，
    ''' 可在“Input Param”（输入参数）选项卡上找到此按钮。“GetEmployees”存储过程需要
    ''' 单个输入参数。执行存储过程并使用 DataGrid
    ''' 显示结果。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnGetEmployees_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetEmployees.Click
        Dim employeesTableAdapter As New StoredProceduresDemoDataSetTableAdapters.GetEmployeesByNameTableAdapter()
        Dim typedDataset As New StoredProceduresDemoDataSet()

        ' 添加存储过程所需的参数。将输入
        ' 参数的值设置为 ComboBox 控件的选定值。
        ' 下面的语法是添加一个 SqlParameter 并
        ' 设置其属性的较长方式。请查看 btnGetProductCountAndAvgPrice_Click
        ' 事件处理程序了解较短的语法。
        Try
            ' 使用 TableAdapter 类型化方法填充数据集
            employeesTableAdapter.Fill(typedDataset.GetEmployeesByName, CStr(cboCategoriesInputParam.SelectedValue))
        Catch expSQL As SqlException
            MsgBox(expSQL.ToString, MsgBoxStyle.OkOnly, "SQL Exception")
            Exit Sub
        End Try

        ' 将 DataGridView 绑定到数据集中所需的表上。
        ' 这将使产品信息显示出来。
        productsGrid.DataSource = typedDataset.GetEmployeesByName

    End Sub
#End Region

#Region "获取 <No Params>（无参数）选项卡的 <First Names>（名字）"
    ' 此子例程处理“List of First Names”（名字列表）按钮的 Click 事件，
    ' 可在“No Params”（无参数）选项卡上找到此按钮。此处使用的存储过程不需要
    ' 输入参数。
    Private Sub getListOfFirstNames_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles getListOfFirstNames.Click

        Dim sb As New StringBuilder()
        Using conn As New SqlConnection(My.Settings.NorthwindConnectionString)
            ' SqlCommand 对象负责执行 SQL 语句
            ' 和管理关联的 SQL 对象，如参数。通过 ad
            ' hoc SQL，您可以将 SQL 语句作为构造函数的第一个参数传递。
            ' 但使用存储过程时，您仅需传递
            ' 存储过程的名称，并将 CommandType 属性
            ' 设置为 CommandType.StoredProcedure 枚举。
            Dim scmd As New SqlCommand("GetFirstNames", conn)
            scmd.CommandType = CommandType.StoredProcedure

            ' 打开到数据库的连接并执行命令，同时传入
            ' 立即关闭连接的枚举值。这是显式调用
            ' dbConnection.Close() 的一个选项。
            conn.Open()
            Using dataReader As SqlDataReader = scmd.ExecuteReader(CommandBehavior.CloseConnection)
                ' 实例化一个 StringBuilder 以连接在文本框中
                ' 显示的字符串。StringBuilder 类为连接进行了优化，
                ' 并且比传统的 &= 方法更优先。
                sb.AppendLine("First Name")
                sb.AppendLine("========================")
                ' 依次通过 SqlDataReader 对象的内容。
                While dataReader.Read
                    sb.AppendLine(dataReader.GetString(0))
                End While
            End Using
        End Using

        ' 显示结果。
        txtTenMostExpProds.Text = sb.ToString
    End Sub
#End Region

#Region "选项卡更改事件"
    ' 此子例程处理 TabControl 的 SelectedIndexChanged。
    ' 它确保用户不能在创建存储过程之前运行任何示例。
    ' 如果已创建存储过程，则执行“GetEmployees”
    ' 存储过程以填充“Input Param”（输入参数）选项卡和“All Types”（所有类型）
    ' 选项卡页上的产品“Categories”（类别）ComboBox 控件。
    Private Sub tabApp_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles tabApp.SelectedIndexChanged
        If Not _hasCreatedSprocs AndAlso tabApp.SelectedTab.TabIndex > 0 Then
            MessageBox.Show("You must first create the required stored procedures.", _
                Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop)
            tabApp.SelectedIndex = 0
        ElseIf _hasCreatedSprocs AndAlso cboCategoriesInputParam.Items.Count = 0 Then
            Me.FillFirstNames()
            Me.FillCountries()
        End If
    End Sub

    Sub FillFirstNames()
        ' 仅当 ComboBox 控件为空，且已创建存储过程时，
        ' 才填充 ComboBox 控件。

        ' 关于下列代码行的注释，请参见其他
        ' 事件处理程序。
        Using conn As New SqlConnection(My.Settings.NorthwindConnectionString)
            Dim sql As String = _
                "GetFirstNames"
            Dim scmd As New SqlCommand(sql, conn)
            Dim sda As New SqlDataAdapter(scmd)
            Dim dsEmployees As New DataSet
            scmd.CommandType = CommandType.StoredProcedure

            Try
                ' 填充数据集。
                sda.Fill(dsEmployees)
            Catch expSql As SqlException
                MsgBox(expSql.ToString, MsgBoxStyle.OkOnly, "SQL Exception")
            End Try

            ' 将数据绑定到 ComboBox 控件
            With cboCategoriesInputParam
                .DataSource = dsEmployees.Tables(0)
                .DisplayMember = "FirstName"
                .ValueMember = "FirstName"
            End With
        End Using

    End Sub

    Sub FillCountries()
        ' 仅当 ComboBox 控件为空，且已创建存储过程时，
        ' 才填充 ComboBox 控件。
        Using conn As New SqlConnection(My.Settings.NorthwindConnectionString)
            Dim sql As String = _
                "GetCountryNames"
            Dim scmd As New SqlCommand(sql, conn)
            Dim sda As New SqlDataAdapter(scmd)
            Dim dsEmployees As New DataSet
            scmd.CommandType = CommandType.StoredProcedure

            Try
                ' 填充数据集。
                sda.Fill(dsEmployees)
            Catch expSql As SqlException
                MsgBox(expSql.ToString, MsgBoxStyle.OkOnly, "SQL Exception")
                Exit Sub
            End Try

            ' 将数据绑定到 ComboBox 控件
            With cboCountries
                .DataSource = dsEmployees.Tables(0)
                .DisplayMember = "Country"
                .ValueMember = "Country"
            End With
        End Using

    End Sub
#End Region

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class